﻿* Encoding: UTF-8.


***************************************************             OWN HOUSE USE VALUE            **********************************************  .

cd "C:\1 Suriname 2022\Analysis".


***************************************************             OWN HOUSE USE VALUE            **********************************************  .


*****************************               Get variables from the housing section                            ************************************************.



***To estimate the value of the house for those without rent or those with rent but with no value or outliers .


***Get the value of rent paid from Module 14.b   variable code 1101

GET  FILE='RT141_Non_Food.sav' 
   / keep =  hhid domain2 domain gp_subdom nfcode q14_d2_ q14_d2 Year_s Month_s.

FILTER OFF.
USE ALL.
SELECT IF (nfcode = 1101).
EXECUTE.

***270 cases 

***263 cases  (7 cases witout value will be estimated with regression).

COMPUTE aaa=q14_d2 - q14_d2_  .
EXECUTE.

FREQUENCIES VARIABLES=aaa
  /ORDER=ANALYSIS.

***  Only 0's  This mean that for this product, the reported values are unchanged.

***All rents were from last month.  Use the CPI value from the survey month and year.

COMPUTE Year=Year_s.
COMPUTE Month=Month_s.
EXECUTE.

formats Year Month (F8.0) .
VARIABLE LEVEL Month (ordinal) .

***Merge with the CPI data.

SORT CASES BY Year(A) Month(A).

MATCH FILES /FILE=*
  /TABLE='Inflation CPI food and non food 2016 2023.sav'
  /BY Year Month.
EXECUTE.

***The base month is June 2022.  The CPI for that month is 453.224

COMPUTE CPI_adjuster=453.224/CPI.
VARIABLE LABELS  CPI_adjuster 'To adjust SDR to June 2022 (multiplier)'.
EXECUTE.

COMPUTE q14_d2 = CPI_adjuster * q14_d2 . 
COMPUTE q14_d2_ = CPI_adjuster * q14_d2_ . 
EXECUTE. 

*** Anualize the value .

compute rent_paid = q14_d2_   * 12 .
variable label rent_paid "Rent paid for the house/Year/June 2022 SRDs" .

***Create a new Domain variable joining 1.2 and 3 because their rental value is very similar.  

RECODE domain2 (1.1=1.1) (1.2=1.2) (2=2) (3=1.2) INTO Domain3.
EXECUTE.

AGGREGATE
  /OUTFILE=* MODE=ADDVARIABLES
  /BREAK= Domain3
  /rent_paid_mean=MEAN(rent_paid) 
  /rent_paid_sd=SD(rent_paid).

COMPUTE  SDM=ABS (RND (  (( rent_paid - rent_paid_mean)/rent_paid_sd)   ,0.1) ).
EXECUTE.

FREQUENCIES VARIABLES=SDM
  /ORDER=ANALYSIS.

***All the values are 4 or less standard deviations from the mean:  do not change any reported value.

DELETE VARIABLES  rent_paid_mean rent_paid_sd SDM  .

format  rent_paid (comma8.0) .

RECODE rent_paid (Lowest thru 0=-1).
EXECUTE.

SORT CASES BY hhid(A).

SAVE OUTFILE='borrar17.sav'
  /keep =  hhid  rent_paid.

*************.

GET FILE='borrar17.sav'  .

***Average yearly rent paid:   2022   SRD 24,092 (median = 17,016) .  CPI JUNE 2022 = 453.224
                                                                                      

*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.

***Get the file with the house characteristics and add the rent paid .

GET   FILE='RT001_Housing_plus.sav'.

SORT CASES BY hhid(A).

MATCH FILES /FILE=*
  /FILE='borrar17.sav'
  /BY hhid.
EXECUTE.

***The 7 cases that reported rent values de 0 or -1 also reported  Private rented/leased (Q13_02 = 5) .

IF  (rent_paid > 0) ln_rent_paid=LN(rent_paid).
VARIABLE LABELS  ln_rent_paid 'Natural logarith of rent paid/Year/June 2022 SRDs'.
EXECUTE.

COMPUTE q13_18_pc = q13_18 / HHsize.
COMPUTE q13_19_pc = q13_19 / HHsize.
COMPUTE q13_20_pc = q13_20 / HHsize.
COMPUTE q13_21_pc = q13_21 / HHsize.
COMPUTE q13_22_pc = q13_22 / HHsize.
EXECUTE.

***ID posible correlates to rent paid.

USE ALL.
COMPUTE filter_$=(rent_paid > 0).
FILTER BY filter_$.
EXECUTE.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_04.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_18.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_19.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_20.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_21.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER q13_22.


RECODE q13_12a q13_12b q13_12c q13_12d q13_12e q13_12f q13_12g (SYSMIS=0).
EXECUTE.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=q13_01 q13_02 q13_03 q13_05 q13_08 q13_09 q13_10 q13_11 q13_12a q13_12b 
    q13_12c q13_12d q13_12e q13_12f q13_12g q13_13 q13_14 q13_15 q13_16 q13_17 q13_23a q13_23b q13_23c 
    q13_23d q13_23e q13_23f  q13_23h q13_23i q13_23j q13_23k q13_23l q13_23m q13_23n q13_24 rent_paid 
    DISPLAY=DEFAULT
  /TABLE q13_01 [C] + q13_02 [C] + q13_03 [C] + q13_05 [C] + q13_08 [C] + q13_09 [C] + q13_10 [C] + 
    q13_11 [C] + q13_12a [C] + q13_12b [C] + q13_12c [C] + q13_12d [C] + q13_12e [C] + q13_12f [C] + 
    q13_12g [C] + q13_13 [C] + q13_14 [C] + q13_15 [C] + q13_16 [C] + q13_17 [C] + q13_23a [C] + 
    q13_23b [C] + q13_23c [C] + q13_23d [C] + q13_23e [C] + q13_23f [C] + q13_23h [C] + 
    q13_23i [C]  + q13_23j [C] +  q13_23k  [C] + q13_23l  [C] +  q13_23m  [C] +  q13_23n  [C] 
    + q13_24 [C] BY rent_paid [S][MEAN, COUNT F40.0]
  /CATEGORIES VARIABLES=q13_01 [1, 2, 3, 4, 5] EMPTY=EXCLUDE
  /CATEGORIES VARIABLES=q13_02 q13_03 q13_05 q13_08 q13_09 q13_10 q13_11 q13_13 q13_14 q13_15 
    q13_16 q13_17 q13_24 ORDER=A KEY=VALUE EMPTY=INCLUDE
  /CATEGORIES VARIABLES=q13_12a q13_12b q13_12c q13_12d q13_12e q13_12f q13_12g q13_23a q13_23b 
    q13_23c q13_23d q13_23e q13_23f q13_23h q13_23i ORDER=A KEY=VALUE EMPTY=EXCLUDE.

* Custom Tables.
CTABLES
  /VLABELS VARIABLES=domain domain2 rent_paid DISPLAY=DEFAULT
  /TABLE domain [C] + domain2 [C] BY rent_paid [S][MEAN, COUNT F40.0]
  /CATEGORIES VARIABLES=domain domain2 ORDER=A KEY=VALUE EMPTY=INCLUDE.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_18_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_19_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_20_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_21_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER Q13_22_PC.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT rent_paid
  /METHOD=ENTER HHsize.

FILTER OFF.
USE ALL.
EXECUTE.

COMPUTE paramaribo = (DOMAIN2 = 1.1) .
COMPUTE Outskirts_interior= (DOMAIN2 = 1.2 or DOMAIN2 = 3).
execute .

COMPUTE q13_01_2_3= (q13_01 = 2 or q13_01 = 3) .
COMPUTE q13_08_5 = (q13_08 = 5) .
COMPUTE q13_09_1 = (q13_09 = 1) .
COMPUTE q13_10_1_4 = (q13_10 = 1 or q13_10 =4) .
COMPUTE q13_12a_1 = (q13_12a = 1) .
COMPUTE q13_12b_1 = (q13_12b = 1) .
COMPUTE q13_12c_1 = (q13_12c = 1) .
COMPUTE q13_12d_1 = (q13_12d = 1) .
COMPUTE q13_12f_1 = (q13_12f = 1) .
COMPUTE q13_12g_1 = (q13_12g = 1) .
COMPUTE q13_14_1 = (q13_14 = 1) .
COMPUTE q13_15_1 = (q13_15 = 1) .
COMPUTE q13_23c_1 = (q13_23c > 0) .
COMPUTE q13_23d_1 = (q13_23d > 0) .
COMPUTE q13_23e_1 = (q13_23e > 0) .
COMPUTE q13_23f_1 = (q13_23f > 0) .


Variable label  paramaribo "Paramaribo".
Variable label  Outskirts_interior "Outkirts of Paramaribo or the interior".
Variable label q13_08_5 "Outer house walls of building stones" .
Variable label  q13_12d_1 "House with security bars in all windows".
Variable label q13_15_1 "Pipe water in the dwelling".
Variable label q13_23c_1 "Water tank in the house".
Variable label q13_23d_1 "Solar water heater in the house".

SAVE OUTFILE='f House1.sav'  .

*************.

GET FILE='f House1.sav'  .

*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.
*****************************               Get variables from the housing section                            ************************************************.




*****************************             Estimate regresion with the LN(rent paid)                         ************************************************.
*****************************             Estimate regresion with the LN(rent paid)                         ************************************************.
*****************************             Estimate regresion with the LN(rent paid)                         ************************************************.

GET FILE='f House1.sav'  
  /keep = hhid domain2 psu weight2 domain Year_s Month_s HHsize 
 rent_paid ln_rent_paid paramaribo Outskirts_interior q13_04 q13_01_2_3 
    q13_08_5 q13_09_1 q13_10_1_4 q13_12a_1 q13_12b_1 q13_12c_1 q13_12d_1 q13_12f_1 q13_12g_1 q13_14_1 
    q13_15_1 q13_23c_1 q13_23d_1 q13_23e_1 q13_23f_1 q13_18_pc q13_19_pc q13_22_pc  q13_18 q13_19 .

FREQUENCIES VARIABLES=hhid rent_paid ln_rent_paid paramaribo Outskirts_interior q13_04 q13_01_2_3 
    q13_08_5 q13_09_1 q13_10_1_4 q13_12a_1 q13_12b_1 q13_12c_1 q13_12d_1 q13_12f_1 q13_12g_1 q13_14_1 
    q13_15_1 q13_23c_1 q13_23d_1 q13_23e_1 q13_23f_1 q13_18_pc q13_19_pc q13_22_pc q13_18 q13_19 
  /FORMAT=NOTABLE
  /STATISTICS=MEAN
  /ORDER=ANALYSIS.

***Only  rent_paid   &    ln_rent_paid   have missing value. 

***All the independent (X's) variables have values.

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER paramaribo Outskirts_interior q13_04 q13_01_2_3 q13_08_5 q13_09_1 q13_10_1_4 
    q13_12a_1 q13_12b_1 q13_12c_1 q13_12d_1 q13_12f_1 q13_12g_1 q13_14_1 q13_15_1 q13_23c_1 q13_23d_1 
    q13_23e_1 q13_23f_1 q13_18_pc q13_19_pc q13_22_pc q13_18 q13_19.


***Do not use if P  > 0.5 .

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER paramaribo Outskirts_interior q13_04 q13_01_2_3 q13_08_5 q13_10_1_4 q13_12b_1 
    q13_12c_1 q13_12d_1 q13_12f_1 q13_14_1 q13_15_1 q13_23c_1 q13_23d_1 q13_23e_1 q13_18_pc q13_22_pc.


***Do not use if P  > 0.25 .

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER paramaribo Outskirts_interior q13_01_2_3 q13_08_5 q13_12c_1 q13_12d_1 q13_12f_1 
    q13_15_1 q13_23c_1 q13_23d_1 q13_22_pc.

***Do not use if P  > 0.16 .

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER paramaribo Outskirts_interior q13_01_2_3 q13_08_5 q13_12d_1 q13_15_1 q13_23c_1 
    q13_23d_1 q13_22_pc.

***Do not use if P  > 0.10  .

REGRESSION
  /MISSING LISTWISE
  /STATISTICS COEFF OUTS R ANOVA
  /CRITERIA=PIN(.05) POUT(.10)
  /NOORIGIN 
  /DEPENDENT ln_rent_paid
  /METHOD=ENTER paramaribo Outskirts_interior q13_08_5 q13_12d_1 q13_15_1 q13_23c_1 q13_23d_1
  /SAVE PRED.

COMPUTE est_rent=EXP(PRE_1).
VARIABLE LABELS  est_rent 'Rent estimated with regression /year/HH/June 2022 SRDs'.
EXECUTE.

DESCRIPTIVES VARIABLES=est_rent rent_paid
  /STATISTICS=MEAN STDDEV MIN MAX.

***The estimated rent average value (SRD 17,180 )is lower and the range is smaller than actual rent paid (SRD 24,092).

COMPUTE rent=rent_paid.
VARIABLE LABELS  rent 'Rent paid (M14.B.1101) / HH /year/June 2022 SRDs'.
EXECUTE.

***7 hH reported renting but provided no value .

compute rent_ex = 0 .
IF  (rent_paid <= 0) rent_ex=PRE_1.
IF  (rent_paid <= 0) rent=PRE_1.
EXECUTE.

IF  (MISSING(rent)) house=est_rent.
VARIABLE LABELS  house 'Use value of house estimated with regresion / HH /year/June 2022 SRDs'.
EXECUTE.

FREQUENCIES VARIABLES=rent house
  /FORMAT=NOTABLE
  /ORDER=ANALYSIS.

RECODE rent house (SYSMIS=0).
EXECUTE.

IF  ((rent = 0 and house > 0) or (house = 0 and rent > 0)) OK=1.
VARIABLE LABELS  OK 'Use value of house estimated with regresion Year/HH/June 2022 SRDs'.
EXECUTE.

FREQUENCIES VARIABLES=OK
  /ORDER=ANALYSIS.

***All HH have value in the rent variable or the house variable. 

SORT CASES BY hhid(A) .

compute house_ex = 0 .
execute .

VARIABLE LEVEL  rent   rent_ex   house   house_ex (scale) .
FORMATS  rent rent_ex house house_ex (Comma8.2) .

VARIABLE LABELS  house_ex 'Estimated Use value of house estimated with regresion / HH /year/June 2022 SRDs'.
VARIABLE LABELS  rent_ex 'Estimated Rent paid (M14.B.1101) / HH /year/June 2022 SRDs'.

SAVE OUTFILE='f House2.sav' 
   /keep  =  hhid rent rent_ex house house_ex  .

*************.

GET FILE='f House2.sav'  .

******************************************************************************************************************************************************************************.

ERASE file ='borrar17.sav' . 


****** edu1   food1   heal1   food2 toba   tran1   tran2   fun1   comm1    food3  rent    house     .





